<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('theme_prayer_points', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('church_id')->nullable();
            $table->unsignedBigInteger('prayer_category_id')->nullable();
            $table->unsignedBigInteger('prayer_sub_category_id')->nullable();
            $table->text('theme_prayer_point')->nullable();
            $table->foreign('church_id')->references('id')->on('churches')->onDelete('cascade');
            $table->foreign('prayer_sub_category_id')->references('id')->on('prayer_sub_categories')->onDelete('cascade');
            $table->foreign('prayer_category_id')->references('id')->on('prayer_categories')->onDelete('cascade');
            $table->enum('status', ['Active', 'Inactive'])->default('Active');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('theme_prayer_points');
    }
};
