<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
          
            $table->id();
            $table->string('first_name')->nullable();
            $table->string('last_name')->nullable();
            $table->string('email')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->string('phone_no')->nullable();
            $table->string('profile_photo')->nullable();
            $table->unsignedBigInteger('church_membership_id')->nullable();
            $table->enum('user_role', [
                'Prayer Warrior', 
                'Pastor', 
                'Prayer (Leader)', 
                'Senior Prayer Warrior (Leader)'
               
            ])->default('Prayer Warrior');
            $table->enum('user_status', [
                'Prayer Warrior', 
                'Champion Warrior', 
                'Elite Warrior'
            ])->default('Prayer Warrior');
            $table->unsignedBigInteger('church_id')->nullable();
            $table->rememberToken();
            $table->foreign('church_id')->references('id')->on('churches')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
