<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PrayerSubCategory extends Model
{
    use HasFactory;
    
    protected $fillable = ['prayer_category_id','prayer_sub_cat_name','prayer_sub_cat_description'];
    public function category()
    {
        return $this->belongsTo(PrayerCategory::class, 'prayer_category_id');
    }

    public function prayerPoints()
    {
        return $this->hasMany(PrayerPoint::class, 'prayer_sub_category_id');
    }
}
